/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.charts;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.apachecommons.lang.text.StrTokenizer;
import org.sonar.api.utils.SonarException;

@Deprecated
public class ChartParameters {
    private static final String[] EMPTY = new String[0];
    public static final String PARAM_WIDTH = "w";
    public static final String PARAM_BACKGROUND_COLOR = "bgc";
    public static final String PARAM_HEIGHT = "h";
    public static final int MAX_WIDTH = 900;
    public static final String PARAM_LOCALE = "locale";
    public static final int MAX_HEIGHT = 900;
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 200;
    private final Map<String, String> params;

    public ChartParameters(Map<String, String> params) {
        this.params = params;
    }

    public ChartParameters(String queryString) {
        String[] groups;
        this.params = new HashMap<String, String>();
        for (String group : groups = StringUtils.split(queryString, "&")) {
            String[] keyval = StringUtils.split(group, "=");
            this.params.put(keyval[0], keyval[1]);
        }
    }

    public String getValue(String key) {
        return this.getValue(key, "", false);
    }

    public String getValue(String key, String defaultValue, boolean decode) {
        String val = this.params.get(key);
        if (decode) {
            val = ChartParameters.decode(val);
        }
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }

    public String[] getValues(String key, String delimiter) {
        String value = this.params.get(key);
        if (value != null) {
            return StringUtils.split(value, delimiter);
        }
        return EMPTY;
    }

    public String[] getValues(String key, String delimiter, boolean decode) {
        String value = this.params.get(key);
        if (value != null) {
            if (decode) {
                value = ChartParameters.decode(value);
            }
            return new StrTokenizer(value, delimiter).setIgnoreEmptyTokens(false).getTokenArray();
        }
        return EMPTY;
    }

    public int getWidth() {
        int width = Integer.parseInt(this.getValue(PARAM_WIDTH, Integer.toString(200), false));
        return Math.min(width, 900);
    }

    public int getHeight() {
        int height = Integer.parseInt(this.getValue(PARAM_HEIGHT, Integer.toString(200), false));
        return Math.min(height, 900);
    }

    public Locale getLocale() {
        String locale = this.getValue(PARAM_LOCALE);
        if (StringUtils.isNotBlank(locale)) {
            return new Locale(locale);
        }
        return Locale.ENGLISH;
    }

    private static String decode(@Nullable String val) {
        if (val != null) {
            try {
                val = URLDecoder.decode(val, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SonarException("Decoding chart parameter : " + val, e);
            }
        }
        return val;
    }
}

